define(['underscore', 'backbone', 'App', 'models/request-model'], function(_, Backbone, app, Model) {
    'use strict';

    return Backbone.Collection.extend({
        model: Model,
        comparator: function(model) {
            return -new Date(model.get('lastUpdatedDate'));
        },
        parse: function(response) {
            // reject booked requests
            var hideCCFlag = typeof app.disabledFeatures.get('CC_FEATURE_SET') === 'undefined';
            return _.filter(response.appointmentRequests, function(request) {
                var isBooked = request.status === 'Booked';
                if (!isBooked) {
                    // set last access date
                    request.lastAccessDate = response.lastAccessDate;
                }

                // eslint-disable-next-line vars-on-top
                var isVA = typeof request.ccAppointmentRequest === 'undefined';
                if (isVA) {
                    return !isBooked;
                }

                return !isBooked && hideCCFlag;

            }, this);
        },
        totalSubmittedRequestsOfType: function(typeId) {
            return this.where({status: 'Submitted', typeOfCareId: typeId}).length;
        },
    });
});
